(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20448,        694]*)
(*NotebookOutlinePosition[     33019,        996]*)
(*  CellTagsIndexPosition[     32244,        970]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Find...", "Command",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find", "SR"],
  " searches the current notebook for matches to the text contained in the \
\"Search for:\" field of the dialog box"
}], "Usage",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Once a match has been found in the notebook, choosing \
",
  StyleBox["Replace", "SR"],
  " in the Find menu replaces the selected match with the new text contained \
in the \"Replace with:\" field."
}], "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Find", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["\<\
Searches forward for the next occurrence after your current \
selection in the notebook.\
\>", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Previous", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Searches backward from the current selection.", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["All", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["\<\
Searches and selects all cells containing an occurrence of the \
search string. \
\>", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Ignore Case", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["When checked, conducts a case-insensitive search.", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Wrap Around", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "When checked, starts at the current selection in the notebook and \
continues to the same point. Otherwise, ",
  StyleBox["Find", "SR"],
  " stops at the end of the file."
}], "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Once your search string has been entered, it can be \
used by all the commands in the Find menu including ",
  StyleBox["Find Next", "SR"],
  ", ",
  StyleBox["Replace", "SR"],
  ", ",
  StyleBox["Replace All", "SR"],
  ", and ",
  StyleBox["Replace and Find Again", "SR"],
  ". The ",
  StyleBox["Enter Selection", "SR"],
  " command in the Find menu is a convenient way to copy text from your \
notebook into the Find dialog box."
}], "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["The Find dialog box ",
    FontWeight->"ExtraLight"],
  "searches the contents of cells only. Use ",
  StyleBox["Find in Cell Tags", "SR"],
  " to search cell tags. "
}], "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]", "C1"],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"FindDialog"],

Cell[CellGroupData[{

Cell["Enter Selection", "Command",
  CellTags->"SetSelectionFind"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Enter Selection", "SR"],
  " places the currently selected text string into the \"Search for:\" field \
of the Find dialog box."
}], "Usage",
  CellTags->"SetSelectionFind"],

Cell[TextData[{
  "\[FilledSmallSquare] If you follow this command with the ",
  StyleBox["Find Next", "SR"],
  " command, for example, you can conduct a search without having to open the \
Find dialog box."
}], "Notes",
  CellTags->"SetSelectionFind"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SetSelectionFind"],

Cell[CellGroupData[{

Cell["Find Next", "Command",
  CellTags->"NotebookFindNext"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Next", "SR"],
  " searches for the next occurrence of the text string entered in the Find \
dialog box."
}], "Usage",
  CellTags->"NotebookFindNext"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Next", "SR"],
  " starts at the current selection. The \"Wrap Around\" option in the Find \
dialog box toggles whether to stop at the end of the file."
}], "Notes",
  CellTags->"NotebookFindNext"],

Cell[TextData[{
  "\[FilledSmallSquare] To specify the search string, use either the ",
  StyleBox["Find", "SR"],
  " or the ",
  StyleBox["Enter Selection", "SR"],
  " command."
}], "Notes",
  CellTags->"NotebookFindNext"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["F3", "C1MR"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["g", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["g", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"NtebookFindNext"],

Cell[CellGroupData[{

Cell["Find Previous", "Command",
  CellTags->"NotebookFindPrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Previous", "SR"],
  " searches backwards in the notebook for the text string entered in the \
Find dialog box."
}], "Usage",
  CellTags->"NotebookFindPrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Previous", "SR"],
  " starts at the current selection. The \"Wrap Around\" option in the Find \
dialog box toggles whether to stop  at the end of the file."
}], "Notes",
  CellTags->"NotebookFindPrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] To specify the search string, use either the ",
  StyleBox["Find", "SR"],
  " or the ",
  StyleBox["Enter Selection", "SR"],
  " command."
}], "Notes",
  CellTags->"NotebookFindPrevious"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find in Cell Tags", "Command",
  CellTags->"SelectionCellTagsFind"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find in Cell Tags", "SR"],
  " searches for a cell tag that matches the selected word."
}], "Usage",
  CellTags->"SelectionCellTagsFind"],

Cell[TextData[
"\[FilledSmallSquare] This command copies the selected word into the Find \
dialog box, and then selects the next cell associated with that cell tag."], 
  "Notes",
  CellTags->"SelectionCellTagsFind"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Replace", "Command",
  CellTags->"Replace"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Replace", "SR"],
  " replaces selected text with the replacement text specified in the Find \
dialog box."
}], "Usage",
  CellTags->"Replace"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Replace"],

Cell[CellGroupData[{

Cell["Replace and Find Again", "Command",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Replace and Find Again", "SR"],
  " does a replacement followed by a find."
}], "Usage",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] This command replaces the selected text and then \
finds the next occurrence of the search text. This is an automatic \
combination of the ",
  StyleBox["Replace", "SR"],
  " and ",
  StyleBox["Find Again", "SR"],
  " commands."
}], "Notes",
  CellTags->"ReplaceFind"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["R", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["R", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["R", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ReplaceandFind"],

Cell[CellGroupData[{

Cell["Replace All", "Command",
  CellTags->"ReplaceAll"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Replace All", "SR"],
  " does all applicable replacements in the notebook, starting with the \
current selection and continuing to the end of the file."
}], "Usage",
  CellTags->"ReplaceAll"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] When \"Wrap around\" is checked in the ",
  StyleBox["Find", "SR"],
  " dialog box, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " replaces all occurrences before, as well as after, the current \
selection."
}], "Notes",
  CellTags->"ReplaceAll"],

Cell[CellGroupData[{

Cell["Open Selected", "Command",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Selected", "SR"],
  " opens the cell group(s) containing the selection."
}], "Usage",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] This command is typically used after ",
  StyleBox["Find All", "SR"],
  " in the Find dialog box. When you click \"All\" in the Find dialog box, \
matches may be found in multiple cells throughout the notebook. If cell \
groups are closed, the selections will not be visible. You can still copy or \
replace the selected matches. Choose ",
  StyleBox["Open Selected", "SR"],
  " if you want to see the matched text."
}], "Notes",
  CellTags->"OpenSelectionParents"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scroll to Selection", "Command",
  CellTags->"SelectionScroll"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Scroll to Selection", "SR"],
  " scrolls to make the current selection visible."
}], "Usage",
  CellTags->"SelectionScroll"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(NeXT)", "Notes"]
}], "Notes",
  CellTags->"SelectionScroll"],

Cell[CellGroupData[{

Cell["Go Back", "Command",
  CellTags->"HyperlinkGoBack"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Go Back", "SR"],
  " returns from a hyperlink jump to the place you started."
}], "Usage",
  CellTags->"HyperlinkGoBack"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Add/Remove Cell Tags...", "Command",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Add/Remove Cell Tags", "SR"],
  " adds or removes the cell tags associated with selected cells."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[
"\[FilledSmallSquare] Cell tags are used to find single cells or classes of \
cells. For example, all title cells could be given the tag \"Title\", and all \
cells related to a particular subject could be given a cell tag identifying \
that subject."], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[
"\[FilledSmallSquare] To add a new cell tag to the selected cell or cells, \
type a word in the \"Cell Tag:\" text box, then click Add. You can add or \
remove multiple cell tags at once. Separate each cell tag with commas."], 
  "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  "attaches the specified cell tag to each of the selected cells. The cell \
tags are not visible unless ",
  StyleBox["Show Cell Tags", "SR"],
  " in the Find menu is checked."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] All cell tags defined in a particular notebook are \
visible in the Cell Tags submenu under the Find menu. You can use either the \
Cell Tags submenu or the ",
  StyleBox["Find in Cell Tags", "SR"],
  " command to search for cells according to their cell tags."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellTagsEditDialog"],

Cell[CellGroupData[{

Cell["Cell Tags", "Command",
  CellTags->"MenuListTags"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Tags", "SR"],
  " finds and selects cells on the basis of their cell tags."
}], "Usage",
  CellTags->"MenuListTags"],

Cell[TextData[
"\[FilledSmallSquare] This submenu lists all cell tags defined in the current \
notebook. Choosing one selects all the cells having that cell tag, and \
scrolls the notebook so that the first of these is visible."], "Notes",
  CellTags->"MenuListTags"],

Cell[TextData[{
  "\[FilledSmallSquare] See:  ",
  ButtonBox["Add/Remove Cell Tags",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"MenuListTags"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Cell Tags", "Command",
  CellTags->"ShowCellTags"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Cell Tags", "SR"],
  " toggles the display of cell tags in the current notebook."
}], "Usage",
  CellTags->"ShowCellTags"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cell Tags From In/Out Names", "Command",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Tags From In/Out Names", "SR"],
  " gives the selected cell a tag that is the same as its current input or \
output prompt."
}], "Usage",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] Ordinarily, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s  ",
  StyleBox["In[]:=", "MO",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Out[]=", "MO",
    FontSlant->"Italic"],
  " prompts (CellLabels) disappear when you close a notebook. That is because \
the numbers associated with input and output cells are only relevant during a \
particular ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Notes",
  CellTags->"CellLabelsToTags"],

Cell[TextData[
"\[FilledSmallSquare] If you want to preserve the In/Out prompts in your \
notebook, perhaps for publication reasons, you can make them into cell tags \
and then show the cell tags. "], "Notes",
  CellTags->"CellLabelsToTags"]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] This command also allows you to locate particular \
In/Out lines by using the Cell Tags submenu."], "Notes",
  CellTags->"CellLabelsToTags"],

Cell[CellGroupData[{

Cell["Make Index...", "Command",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make Index", "SR"],
  " creates an index from the cell tags in a notebook."
}], "Usage",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Make Index", "SR"],
  " command paginates your notebook, and then figures out what page each cell \
is on. When a cell has a cell tag, an entry is created in the index with that \
keyword and its corresponding page number(s)."
}], "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[
"\[FilledSmallSquare] The index is copied onto the Clipboard, and then can be \
pasted into a notebook or other file."], "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["Form of index references:", "Subsubsection",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Text Format",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["Generates a list of index entries followed by page numbers.", 
  "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Hyperlinks",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["Generates a hyperlink for each cell tag.", "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Page References",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "Generates a list of index entries followed by counter boxes displaying \
their page numbers. This is  valid only when",
  StyleBox[" Show Page Breaks", "SR"],
  " is turned on."
}], "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Section References",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "Generates a list of index entries followed by counter boxes displaying \
their section numbers. This is valid onlywhen ",
  StyleBox["Show Page Breaks", "SR"],
  " is turned on"
}], "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]
}, Open  ]]
},
FrontEndVersion->"NeXT 3.0 Beta 3",
ScreenRectangle->{{0, 1053}, {0, 832}},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{122, Automatic}, {Automatic, 78}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "FindDialog"->{
    Cell[1731, 51, 75, 1, 34, "Command",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[1809, 54, 248, 6, 43, "Usage",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2060, 62, 301, 7, 36, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2364, 71, 75, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2442, 74, 169, 4, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2614, 80, 79, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2696, 83, 118, 1, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2817, 86, 74, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2894, 89, 161, 4, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3058, 95, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3143, 98, 122, 1, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3268, 101, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3353, 104, 259, 6, 34, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3615, 112, 534, 15, 70, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[4152, 129, 283, 8, 70, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[4450, 140, 610, 19, 70, "Notes",
      CellTags->"FindDialog"]},
  "shortFormSearchID"->{
    Cell[1731, 51, 75, 1, 34, "Command",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[1809, 54, 248, 6, 43, "Usage",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2060, 62, 301, 7, 36, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2364, 71, 75, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2442, 74, 169, 4, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2614, 80, 79, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2696, 83, 118, 1, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2817, 86, 74, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2894, 89, 161, 4, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3058, 95, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3143, 98, 122, 1, 20, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3268, 101, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3353, 104, 259, 6, 34, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3615, 112, 534, 15, 70, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[4152, 129, 283, 8, 70, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}]},
  "SetSelectionFind"->{
    Cell[5085, 163, 66, 1, 70, "Command",
      CellTags->"SetSelectionFind"],
    Cell[5154, 166, 228, 6, 70, "Usage",
      CellTags->"SetSelectionFind"],
    Cell[5385, 174, 252, 6, 70, "Notes",
      CellTags->"SetSelectionFind"],
    Cell[5652, 183, 594, 18, 70, "Notes",
      CellTags->"SetSelectionFind"]},
  "NotebookFindNext"->{
    Cell[6271, 205, 60, 1, 70, "Command",
      CellTags->"NotebookFindNext"],
    Cell[6334, 208, 209, 6, 70, "Usage",
      CellTags->"NotebookFindNext"],
    Cell[6546, 216, 256, 6, 70, "Notes",
      CellTags->"NotebookFindNext"],
    Cell[6805, 224, 223, 7, 70, "Notes",
      CellTags->"NotebookFindNext"]},
  "NtebookFindNext"->{
    Cell[7043, 234, 505, 16, 70, "Notes",
      CellTags->"NtebookFindNext"]},
  "NotebookFindPrevious"->{
    Cell[7573, 254, 68, 1, 70, "Command",
      CellTags->"NotebookFindPrevious"],
    Cell[7644, 257, 220, 6, 70, "Usage",
      CellTags->"NotebookFindPrevious"],
    Cell[7867, 265, 265, 6, 70, "Notes",
      CellTags->"NotebookFindPrevious"],
    Cell[8135, 273, 227, 7, 70, "Notes",
      CellTags->"NotebookFindPrevious"]},
  "SelectionCellTagsFind"->{
    Cell[8399, 285, 73, 1, 70, "Command",
      CellTags->"SelectionCellTagsFind"],
    Cell[8475, 288, 192, 5, 70, "Usage",
      CellTags->"SelectionCellTagsFind"],
    Cell[8670, 295, 216, 4, 70, "Notes",
      CellTags->"SelectionCellTagsFind"]},
  "Replace"->{
    Cell[8923, 304, 49, 1, 70, "Command",
      CellTags->"Replace"],
    Cell[8975, 307, 197, 6, 70, "Usage",
      CellTags->"Replace"],
    Cell[9187, 316, 585, 18, 70, "Notes",
      CellTags->"Replace"]},
  "ReplaceFind"->{
    Cell[9797, 338, 68, 1, 70, "Command",
      CellTags->"ReplaceFind"],
    Cell[9868, 341, 170, 5, 70, "Usage",
      CellTags->"ReplaceFind"],
    Cell[10041, 348, 308, 9, 70, "Notes",
      CellTags->"ReplaceFind"]},
  "ReplaceandFind"->{
    Cell[10364, 360, 652, 18, 70, "Notes",
      CellTags->"ReplaceandFind"]},
  "ReplaceAll"->{
    Cell[11041, 382, 56, 1, 70, "Command",
      CellTags->"ReplaceAll"],
    Cell[11100, 385, 246, 6, 70, "Usage",
      CellTags->"ReplaceAll"],
    Cell[11361, 394, 328, 10, 70, "Notes",
      CellTags->"ReplaceAll"]},
  "OpenSelectionParents"->{
    Cell[11714, 408, 68, 1, 70, "Command",
      CellTags->"OpenSelectionParents"],
    Cell[11785, 411, 181, 5, 70, "Usage",
      CellTags->"OpenSelectionParents"],
    Cell[11969, 418, 505, 10, 70, "Notes",
      CellTags->"OpenSelectionParents"]},
  "SelectionScroll"->{
    Cell[12511, 433, 69, 1, 70, "Command",
      CellTags->"SelectionScroll"],
    Cell[12583, 436, 179, 5, 70, "Usage",
      CellTags->"SelectionScroll"],
    Cell[12777, 444, 250, 7, 70, "Notes",
      CellTags->"SelectionScroll"]},
  "HyperlinkGoBack"->{
    Cell[13052, 455, 57, 1, 70, "Command",
      CellTags->"HyperlinkGoBack"],
    Cell[13112, 458, 176, 5, 70, "Usage",
      CellTags->"HyperlinkGoBack"]},
  "CellTagsEditDialog"->{
    Cell[13325, 468, 92, 1, 70, "Command",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13420, 471, 241, 6, 70, "Usage",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13664, 479, 353, 6, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14020, 487, 330, 6, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14353, 495, 439, 13, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14795, 510, 391, 8, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[15201, 521, 590, 18, 70, "Notes",
      CellTags->"CellTagsEditDialog"]},
  "editKeysID"->{
    Cell[13325, 468, 92, 1, 70, "Command",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13420, 471, 241, 6, 70, "Usage",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13664, 479, 353, 6, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14020, 487, 330, 6, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14353, 495, 439, 13, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14795, 510, 391, 8, 70, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}]},
  "MenuListTags"->{
    Cell[15816, 543, 56, 1, 70, "Command",
      CellTags->"MenuListTags"],
    Cell[15875, 546, 176, 5, 70, "Usage",
      CellTags->"MenuListTags"],
    Cell[16054, 553, 267, 4, 70, "Notes",
      CellTags->"MenuListTags"],
    Cell[16324, 559, 173, 6, 70, "Notes",
      CellTags->"MenuListTags"]},
  "ShowCellTags"->{
    Cell[16534, 570, 61, 1, 70, "Command",
      CellTags->"ShowCellTags"],
    Cell[16598, 573, 182, 5, 70, "Usage",
      CellTags->"ShowCellTags"]},
  "CellLabelsToTags"->{
    Cell[16817, 583, 78, 1, 70, "Command",
      CellTags->"CellLabelsToTags"],
    Cell[16898, 586, 229, 6, 70, "Usage",
      CellTags->"CellLabelsToTags"],
    Cell[17130, 594, 518, 17, 70, "Notes",
      CellTags->"CellLabelsToTags"],
    Cell[17651, 613, 241, 4, 70, "Notes",
      CellTags->"CellLabelsToTags"],
    Cell[17907, 620, 177, 3, 70, "Notes",
      CellTags->"CellLabelsToTags"]},
  "CreateIndexDialog"->{
    Cell[18109, 627, 88, 1, 70, "Command",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18200, 630, 199, 5, 70, "Usage",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18402, 637, 354, 7, 70, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18759, 646, 200, 3, 70, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18962, 651, 106, 1, 70, "Subsubsection",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19071, 654, 131, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19205, 658, 142, 2, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19350, 662, 130, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19483, 666, 120, 1, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19606, 669, 135, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19744, 673, 272, 6, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[20019, 681, 138, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[20160, 685, 272, 6, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]},
  "makeIndexDialogID"->{
    Cell[18109, 627, 88, 1, 70, "Command",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18200, 630, 199, 5, 70, "Usage",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18402, 637, 354, 7, 70, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18759, 646, 200, 3, 70, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18962, 651, 106, 1, 70, "Subsubsection",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19071, 654, 131, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19205, 658, 142, 2, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19350, 662, 130, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19483, 666, 120, 1, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19606, 669, 135, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19744, 673, 272, 6, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[20019, 681, 138, 2, 70, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[20160, 685, 272, 6, 70, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"FindDialog", 21177, 715},
  {"shortFormSearchID", 22747, 748},
  {"SetSelectionFind", 24243, 779},
  {"NotebookFindNext", 24582, 788},
  {"NtebookFindNext", 24919, 797},
  {"NotebookFindPrevious", 25026, 800},
  {"SelectionCellTagsFind", 25385, 809},
  {"Replace", 25651, 816},
  {"ReplaceFind", 25880, 823},
  {"ReplaceandFind", 26124, 830},
  {"ReplaceAll", 26221, 833},
  {"OpenSelectionParents", 26471, 840},
  {"SelectionScroll", 26746, 847},
  {"HyperlinkGoBack", 27005, 854},
  {"CellTagsEditDialog", 27189, 859},
  {"editKeysID", 27874, 874},
  {"MenuListTags", 28479, 887},
  {"ShowCellTags", 28801, 896},
  {"CellLabelsToTags", 28977, 901},
  {"CreateIndexDialog", 29400, 912},
  {"makeIndexDialogID", 30822, 939}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 75, 1, 34, "Command",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[1809, 54, 248, 6, 43, "Usage",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2060, 62, 301, 7, 36, "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2364, 71, 75, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2442, 74, 169, 4, 20, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2614, 80, 79, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2696, 83, 118, 1, 20, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2817, 86, 74, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2894, 89, 161, 4, 20, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3058, 95, 82, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3143, 98, 122, 1, 20, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3268, 101, 82, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3353, 104, 259, 6, 34, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3615, 112, 534, 15, 70, "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[4152, 129, 283, 8, 70, "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}]
}, Open  ]],
Cell[4450, 140, 610, 19, 70, "Notes",
  CellTags->"FindDialog"],

Cell[CellGroupData[{
Cell[5085, 163, 66, 1, 70, "Command",
  CellTags->"SetSelectionFind"],
Cell[5154, 166, 228, 6, 70, "Usage",
  CellTags->"SetSelectionFind"],
Cell[5385, 174, 252, 6, 70, "Notes",
  CellTags->"SetSelectionFind"]
}, Open  ]],
Cell[5652, 183, 594, 18, 70, "Notes",
  CellTags->"SetSelectionFind"],

Cell[CellGroupData[{
Cell[6271, 205, 60, 1, 70, "Command",
  CellTags->"NotebookFindNext"],
Cell[6334, 208, 209, 6, 70, "Usage",
  CellTags->"NotebookFindNext"],
Cell[6546, 216, 256, 6, 70, "Notes",
  CellTags->"NotebookFindNext"],
Cell[6805, 224, 223, 7, 70, "Notes",
  CellTags->"NotebookFindNext"]
}, Open  ]],
Cell[7043, 234, 505, 16, 70, "Notes",
  CellTags->"NtebookFindNext"],

Cell[CellGroupData[{
Cell[7573, 254, 68, 1, 70, "Command",
  CellTags->"NotebookFindPrevious"],
Cell[7644, 257, 220, 6, 70, "Usage",
  CellTags->"NotebookFindPrevious"],
Cell[7867, 265, 265, 6, 70, "Notes",
  CellTags->"NotebookFindPrevious"],
Cell[8135, 273, 227, 7, 70, "Notes",
  CellTags->"NotebookFindPrevious"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8399, 285, 73, 1, 70, "Command",
  CellTags->"SelectionCellTagsFind"],
Cell[8475, 288, 192, 5, 70, "Usage",
  CellTags->"SelectionCellTagsFind"],
Cell[8670, 295, 216, 4, 70, "Notes",
  CellTags->"SelectionCellTagsFind"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8923, 304, 49, 1, 70, "Command",
  CellTags->"Replace"],
Cell[8975, 307, 197, 6, 70, "Usage",
  CellTags->"Replace"]
}, Open  ]],
Cell[9187, 316, 585, 18, 70, "Notes",
  CellTags->"Replace"],

Cell[CellGroupData[{
Cell[9797, 338, 68, 1, 70, "Command",
  CellTags->"ReplaceFind"],
Cell[9868, 341, 170, 5, 70, "Usage",
  CellTags->"ReplaceFind"],
Cell[10041, 348, 308, 9, 70, "Notes",
  CellTags->"ReplaceFind"]
}, Open  ]],
Cell[10364, 360, 652, 18, 70, "Notes",
  CellTags->"ReplaceandFind"],

Cell[CellGroupData[{
Cell[11041, 382, 56, 1, 70, "Command",
  CellTags->"ReplaceAll"],
Cell[11100, 385, 246, 6, 70, "Usage",
  CellTags->"ReplaceAll"]
}, Open  ]],
Cell[11361, 394, 328, 10, 70, "Notes",
  CellTags->"ReplaceAll"],

Cell[CellGroupData[{
Cell[11714, 408, 68, 1, 70, "Command",
  CellTags->"OpenSelectionParents"],
Cell[11785, 411, 181, 5, 70, "Usage",
  CellTags->"OpenSelectionParents"],
Cell[11969, 418, 505, 10, 70, "Notes",
  CellTags->"OpenSelectionParents"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12511, 433, 69, 1, 70, "Command",
  CellTags->"SelectionScroll"],
Cell[12583, 436, 179, 5, 70, "Usage",
  CellTags->"SelectionScroll"]
}, Open  ]],
Cell[12777, 444, 250, 7, 70, "Notes",
  CellTags->"SelectionScroll"],

Cell[CellGroupData[{
Cell[13052, 455, 57, 1, 70, "Command",
  CellTags->"HyperlinkGoBack"],
Cell[13112, 458, 176, 5, 70, "Usage",
  CellTags->"HyperlinkGoBack"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13325, 468, 92, 1, 70, "Command",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[13420, 471, 241, 6, 70, "Usage",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[13664, 479, 353, 6, 70, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[14020, 487, 330, 6, 70, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[14353, 495, 439, 13, 70, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[14795, 510, 391, 8, 70, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}]
}, Open  ]],
Cell[15201, 521, 590, 18, 70, "Notes",
  CellTags->"CellTagsEditDialog"],

Cell[CellGroupData[{
Cell[15816, 543, 56, 1, 70, "Command",
  CellTags->"MenuListTags"],
Cell[15875, 546, 176, 5, 70, "Usage",
  CellTags->"MenuListTags"],
Cell[16054, 553, 267, 4, 70, "Notes",
  CellTags->"MenuListTags"],
Cell[16324, 559, 173, 6, 70, "Notes",
  CellTags->"MenuListTags"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16534, 570, 61, 1, 70, "Command",
  CellTags->"ShowCellTags"],
Cell[16598, 573, 182, 5, 70, "Usage",
  CellTags->"ShowCellTags"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16817, 583, 78, 1, 70, "Command",
  CellTags->"CellLabelsToTags"],
Cell[16898, 586, 229, 6, 70, "Usage",
  CellTags->"CellLabelsToTags"],
Cell[17130, 594, 518, 17, 70, "Notes",
  CellTags->"CellLabelsToTags"],
Cell[17651, 613, 241, 4, 70, "Notes",
  CellTags->"CellLabelsToTags"]
}, Open  ]],
Cell[17907, 620, 177, 3, 70, "Notes",
  CellTags->"CellLabelsToTags"],

Cell[CellGroupData[{
Cell[18109, 627, 88, 1, 70, "Command",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18200, 630, 199, 5, 70, "Usage",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18402, 637, 354, 7, 70, "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18759, 646, 200, 3, 70, "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18962, 651, 106, 1, 70, "Subsubsection",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19071, 654, 131, 2, 70, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19205, 658, 142, 2, 70, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19350, 662, 130, 2, 70, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19483, 666, 120, 1, 70, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19606, 669, 135, 2, 70, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19744, 673, 272, 6, 70, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[20019, 681, 138, 2, 70, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[20160, 685, 272, 6, 70, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

